/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.logd;

import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.servlet.logd.ExpanderData;
import com.ibm.hwmca.fw.servlet.logd.FormatTextData;
import com.ibm.hwmca.fw.servlet.logd.GetExpanderData;
import com.ibm.hwmca.fw.servlet.logd.LogBlockData;
import com.ibm.hwmca.fw.servlet.logd.LogDisplayerEvent;
import com.ibm.hwmca.fw.servlet.logd.LogServlet;
import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.cparser.ParserObj;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class HexExpander {
    private static final String TRACE_MASKT = "XLDSHEXT";
    private static final String TRACE_MASKD = "XLDSHEXD";
    private static final String TRACE_MASKF = "XLDSHEXF";
    private static final FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "LogdServ");
    private Map _map;
    private static final char[] ASCII_ARRAY = new char[]{'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.'};
    private static final char[] EBCDIC_ARRAY = new char[]{'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', ' ', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '<', '(', '+', '|', '&', '.', '.', '.', '.', '.', '.', '.', '.', '.', '!', '$', '*', ')', ';', '.', '-', '/', '.', '.', '.', '.', '.', '.', '.', '.', '.', ',', '%', '_', '>', '?', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', ':', '#', '@', '\'', '=', '\"', '.', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '.', '{', '.', '(', '+', '.', '.', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '.', '}', '.', '.', '.', '.', '.', '.', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '.', '.', '.', '.', '.', '.', '.', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '.', '.', '.', '.', '.', '.', '.', '.', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '.', '.', '.', '.', '.', '.', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '.', '.', '.', '.', '.', '.'};
    public static final transient int BYTES_IN_ROW = 16;
    public static final transient int BYTES_IN_ELEMENT = 4;
    public static final transient int CHARS_IN_ADDRESS = 8;
    public static final transient int CHARS_IN_HEX_ELEMENT = 9;
    public static final transient int CHARS_IN_CHAR_ELEMENT = 16;
    public static final transient int NUMBER_COLUMNS_OF_JUST_HEX_DATA = 4;
    public static final transient int NUMBER_COLUMNS = 6;
    private static final String _hexTitle = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.hex.title").toString();
    private static final String _addresses = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.hex.addresses.name").toString();
    private static final String _tableAddress = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.hex.address.name").toString();
    private static final String _tableAscii = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.hex.ascii.name").toString();
    private static final String _tableEbcdic = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.hex.ebcdic.name").toString();
    private static final String _linkAscii = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.link.ascii.name").toString();
    private static final String _linkEbcdic = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.link.ebcdic.name").toString();

    public static char getASCIIChar(int i) {
        return ASCII_ARRAY[i];
    }

    public static char getEBCDICChar(int i) {
        return EBCDIC_ARRAY[i];
    }

    public HexExpander(Map map) throws IOException {
        Trace.trace(TRACE_MASKT, "<> HexExpander()");
        this._map = map;
        this.displayHexData();
    }

    public void displayHexData() throws IOException {
        Trace.trace(TRACE_MASKT, "-> HexExpander.displayText()");
        ExpanderData expanderData = GetExpanderData.getData(this._map);
        if (expanderData.getDataExists()) {
            int numRows;
            byte[] hexData = expanderData.getHexData();
            int hexDataLen = hexData.length;
            if (hexDataLen - (numRows = hexDataLen / 16) * 16 != 0) {
                ++numRows;
            }
            Trace.trace(TRACE_MASKF, "num Rows to display= " + numRows);
            boolean displayDataAsAscii = true;
            HttpServletRequest request = expanderData.getRequest();
            String charType = request.getParameter("chartype");
            if (charType != null && charType.length() != 0) {
                if (charType.equals("ebcdic")) {
                    displayDataAsAscii = false;
                }
                Trace.trace(TRACE_MASKF, "charType=" + charType);
            }
            Trace.trace(TRACE_MASKF, "displayDataAsAscii=" + displayDataAsAscii);
            PrintWriter out = expanderData.getResponse().getWriter();
            LogBlockData logBlockData = expanderData.getLogBlockData();
            out.print("<html> <script src='/js/servlettask/keys.js'></script><head><title>" + _hexTitle + "</title></head>" + "<body onload='window.focus(); hideCancel();' > <pre>");
            out.print(LogServlet.HTML_BACK + "&nbsp;&nbsp;");
            String cType1 = "<A onclick='window.location.replace(this.href); return false;' href=\"logd?reqtype=logblockdata" + LogDisplayerEvent.getEventData(logBlockData) + "&blockid=" + logBlockData.getBlockid() + "&chartype=";
            cType1 = displayDataAsAscii ? cType1 + "ebcdic" : cType1 + "ascii";
            cType1 = cType1 + "\">";
            cType1 = displayDataAsAscii ? cType1 + _linkEbcdic : cType1 + _linkAscii;
            cType1 = cType1 + "</A>" + "<br>&nbsp;<br>";
            out.print(cType1);
            Trace.trace(TRACE_MASKF, "cType1=" + cType1);
            out.print(LogDisplayerEvent.format1EventLog(logBlockData).toString());
            out.print("<br>&nbsp;<br>");
            out.print(_addresses + "&nbsp;&nbsp;" + "0 - " + HexString.toHex(hexDataLen - 1, false).toUpperCase());
            out.print("<br>&nbsp;<br>");
            out.print("<TABLE cellspacing = \"2\" cellpadding = \"2\" border=\"1\" frame=\"box\" rules=\"all\" width=\"90%\" ><COL width=\"15%\"><COL width=\"15%\"><COL width=\"15%\"><COL width=\"15%\"><COL width=\"15%\"><COL width=\"25%\"><TR><TH align=\"left\">" + _tableAddress + "<TH align=\"left\">" + "+0" + "<TH align=\"left\">" + "+4" + "<TH align=\"left\">" + "+8" + "<TH align=\"left\">" + "+C");
            if (displayDataAsAscii) {
                out.print("<TH align=\"left\">" + _tableAscii);
            } else {
                out.print("<TH align=\"left\">" + _tableEbcdic);
            }
            int numSpacesPerRow = 60 + "<TD>".length() * 6;
            Trace.trace(TRACE_MASKF, "num Spaces Per Row =" + numSpacesPerRow);
            StringBuffer str = new StringBuffer(numRows * numSpacesPerRow);
            for (int i = 0; i < numRows; ++i) {
                str.append(this.formatHexData(i, hexData, hexDataLen, displayDataAsAscii));
            }
            out.print(str);
            out.print("</TABLE></pre> </body></html>");
        }
        Trace.trace(TRACE_MASKT, "<- HexExpander.displayHexData()");
    }

    private String formatHexData(int row, byte[] hexData, int hexDataLen, boolean displayDataAsAscii) {
        short address;
        String strChar = "";
        String strHex = "";
        int hexLenMinus1 = hexDataLen - 1;
        strHex = strHex + "<TR>";
        if (hexDataLen > 65535) {
            address = row * 16;
            strHex = strHex + "<TD>" + HexString.toHex((int)address, true).toUpperCase() + "</TD>";
        } else {
            address = (short)(row * 16);
            strHex = strHex + "<TD>" + HexString.toHex(address, true).toUpperCase() + "</TD>";
        }
        int index = row * 16;
        int hexCol = 0;
        for (int i = 1; i <= 4; ++i) {
            for (int j = 0; index < hexDataLen && j < 4; ++index, ++j) {
                if (j == 0) {
                    strHex = strHex + "<TD>";
                    ++hexCol;
                }
                strChar = displayDataAsAscii ? strChar + HexExpander.getASCIIChar(ParserObj.toInt(hexData, 1, index)) : strChar + HexExpander.getEBCDICChar(ParserObj.toInt(hexData, 1, index));
                strHex = strHex + HexString.toHex(hexData[index], true).toUpperCase();
                if (j == 1) {
                    strHex = strHex + "&nbsp;";
                }
                if (j != 3 && index != hexLenMinus1) continue;
                strHex = strHex + "</TD>";
            }
        }
        if (hexCol < 4) {
            for (int k = hexCol; k < 4; ++k) {
                strHex = strHex + "<TD>" + "</TD>";
            }
        }
        strHex = strHex + "<TD>" + FormatTextData.createText(strChar, false) + "</TD>";
        return strHex;
    }
}

